%% Step 1: Quantify Single-Point Sources (Positive Flux Only)
clear all;
close all;

% Define the parent directory containing the folders
parentPath = '\\csunas01.colostate.edu\research\METEC\User\mbua\ADED\Eddy Covariance\8_Hz\Event Tables\Emission Sources\Single_Point';

folders = {'5 minutes','15 minutes','30 minutes'};

% Loop through each folder
for f = 1:numel(folders)
    folderName = folders{f};
    
    % Define the folder path for the current folder
    path = fullfile(parentPath, folderName);

    % Define the Downwind folders
    downwind_dirs = dir(fullfile(path, '* degrees'));
    downwind_folders = {downwind_dirs([downwind_dirs.isdir]).name};

    % Loop through each downwind folder
    for d = 1:numel(downwind_folders)
        downwind_folder = fullfile(path, downwind_folders{d}, 'EC output', 'Footprint_Klujn');
        if ~isfolder(downwind_folder)
            warning('Skipping: %s does not exist', downwind_folder);
            continue;
        end
        
        % Create quantified folder within downwind folder
        quantified_folder = fullfile(downwind_folder, 'Quantified');
        if ~exist(quantified_folder, 'dir')
            mkdir(quantified_folder);
        end

        % Walk through the directory structure
        files = dir(fullfile(downwind_folder, '*.csv')); % Assuming files are CSV format
        for i = 1:numel(files)
            filename = files(i).name;
            file_path = fullfile(downwind_folder, filename);
            
            % Read data and filter negative fluxes
            data = readtable(file_path);
            
            % ===== KEY MODIFICATION =====
            % Remove rows with negative CH4_flux BEFORE processing
            %positive_flux_idx = data.CH4_flux > 0;
           % data = data(positive_flux_idx, :);
            
            % Skip empty files after filtering
            if height(data) == 0
                warning('No positive fluxes found in: %s', filename);
                continue;
            end
            
            % Calculate flux in kg/m²/s (no absolute value needed)
           data.flux = data.CH4_flux * 16.04 * 10^-6;  % Convert µmol/m²/s to g/m²/s
            d
            % Calculate Emission kg/h (only for positive fluxes)
            
            data.Emission_kg_h = 0.001 * 3600 * data.flux ./ data.footprint_Klujn;
            % Save only if there's data remaining
            if height(data) > 0
                writetable(data, fullfile(quantified_folder, files(i).name));
            end
        end
    end 
end
disp('Step 1 Complete: Only positive fluxes processed');


%% Step 2: Quantify Single_Emissions from Multi-point sources

clear all;
close all;

% Define the parent directory containing the folders
parentPath = '\\csunas01.colostate.edu\research\METEC\User\mbua\ADED\Eddy Covariance\8_Hz\Event Tables\Emission Sources\Multi_Point\Emission Point';

folders = {'5 minutes','15 minutes','30 minutes'};
degree_folders = {'10 degrees','20 degrees','45 degrees'};

% Loop through each folder
for f = 1:numel(folders)
    folderName = folders{f};
    
    % Define the folder path for the current folder
    path = fullfile(parentPath, folderName);

% Loop through predefined degree folders
for d = 1:numel(degree_folders)
    degree_folder = degree_folders{d};
    downwind_folder = fullfile(path, degree_folder, 'EC output', 'Footprint_Klujn');

if ~isfolder(downwind_folder)
    warning('Skipping: %s does not exist', downwind_folder);
    continue;
end

        
        % Create quantified folder within downwind folder
        quantified_folder = fullfile(downwind_folder, 'Quantified_positive_flux');
        if ~exist(quantified_folder, 'dir')
            mkdir(quantified_folder);
        end

        % Walk through the directory structure
        files = dir(fullfile(downwind_folder, '*.csv')); % Assuming files are CSV format
        for i = 1:numel(files)
            filename = files(i).name;
            file_path = fullfile(downwind_folder, filename);
           data = readtable(file_path);
         
                       % ===== KEY MODIFICATION =====
            % Remove rows with negative CH4_flux BEFORE processing
            positive_flux_idx = data.CH4_flux > 0;
            data = data(positive_flux_idx, :);
            
            % Skip empty files after filtering
            if height(data) == 0
                warning('No positive fluxes found in: %s', filename);
                continue;
            end
            
            % Calculate flux in kg/m²/s (no absolute value needed)
            data.flux = data.CH4_flux * 16.04 * 10^-6;  % Convert µmol/m²/s to kg/m²/s
        
            % Calculate Emission kg/h
            
            data.Emission_kg_h = 0.001 * 3600 * data.flux./data.footprint_Klujn;
        
         
           % Store the processed table in the cell array
            processed_tables{i} = data;
        
            % Save the updated table back to the file
            writetable(data, fullfile(quantified_folder, files(i).name));
        end
       
    end 
end
disp('Step 2 Complete')